///////////////////////////////////////////////////////////////
// Tornado Valley
///////////////////////////////////////////////////////////////
// Build 25 buildings and reach a total happiness of 120 with high tornadoes disasters and bandit attacks
$tornadoBldgCnt = 25; //25
$tornadoHappyCnt = 120; //120
$tornadoQuest = "Tornado Valley";

// Starts tornado Valley tasks
function startTornadoValleyTasks()
{ 
   InitializeQuestGui();
   GameCamera.FlySpeed = 75;
    
   slgActivateTask("TornadoValleyTasks");
   TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoStart", $TSV_AVAIL);
}
function endTornadoValleyTasks()
{
   tsEndTask("TornadoValleyTasks");
}

////////////////////////////////////////////////////////////////////////////////
//! Rewards the player if the task is successfully completed
////////////////////////////////////////////////////////////////////////////////
function winTornadoValley()
{
   tsModifyResource($Resource::Experience, 100, true);
   tsModifyResource($Resource::Gold, 1000, true);
   SendProductionToClient(HeroCharacter, "100 experience");
   SendProductionToClient(HeroCharacter, "1000 gold");
   //Quest log
   tsCompleteTaskInTracker("Tornado Valley", "Build a town in Tornado Valley.");
   TVdude.deleteobject();
}
////////////////////////////////////////////////////////////////////////////////
//! Reset Tornado Valley Task
////////////////////////////////////////////////////////////////////////////////
function resetTornadoValleyTasks()
{
   TaskModifier.strResetVertex("Campaign2Tasks", "MapTornadoValleyReset");
   TaskModifier.strMarkVertex("Campaign2Tasks", "MapTornadoValleyReset", $TSV_AVAIL);
}

// Short delay than NPC dialog popup
function TornadoStart::onExit()
{
   tsSendTaskPopUpDlg("ID_TASK_TornadoValley", "ID_TornadoStart", $TaskButton::Okay, "tornadociv", "ID_TornadoStart");   
}
function TornadoMove::onExit()
{
   tsMoveObjToTarget("tornadociv", "-182 -376");
}
function TornadoBaseCamp::onExit()
{
   tsSendTaskPopUpDlg("ID_TASK_TornadoValley", "ID_TornadoBasecamp", $TaskButton::More, "tornadociv");
   tsSendTaskPopUpDlg("ID_TASK_TornadoValley", "ID_TornadoMainTask", $TaskButton::Okay, "tornadociv", "ID_TornadoMainTask");  
}

function TornadoDisaster::onExit()
{
   //Change teams
   tsConvertObjTeam("tornadociv", 1);
   tsConvertObjTeam("tornadociv2", 1);
   tsSkinObj("tornadociv", "base");
   tsSkinObj("tornadociv2", "base");
   
   //Quest log
   tsAddQuestToTracker(true, $tornadoQuest, "", "Dorothy Bloom, an eccentric entrepreneur, has challenged anyone to build a prosperous town in the middle of the most dangerous Tornado Valley in the area. Crazy, sure, but she's willing to pay a generous reward for the feat.", "Reward: 1,000 Gold, 100 Experience");
   tsReadyQuest($tornadoQuest);
   tsAddTaskToTracker($tornadoQuest, "Maintain a Town Happiness of "@$tornadoHappyCnt, "The town must be prosperous and happy as well as big. Maintain a Town Happiness of "@$tornadoHappyCnt);
   tsAddTaskToTracker($tornadoQuest, "You have 0 out of "@$tornadoBldgCnt@" buildings needed.", "Build a town of "@$tornadoBldgCnt@" Town Buildings in Tornado Valley.");
      
   TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoBuildingCnt", $TSV_AVAIL);
   TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoDestroyCnt", $TSV_AVAIL);
   TorandoDisasterHigh();
}  

function TorandoDisasterHigh()
{
     %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 70 secs, a disaster can occur
      addDisasterNode = "0 60 3";
      
      // frequency pool, respawning time
      disasterBanditRate = "15 120";
      disasterDroughtRate = "10 60";
      disasterFireRate = "15 120";
      disasterTornadoRate = "60 50"; 
      disasterEarthquakeRate = "0 60";
      disasterFamineRate = "0 60";
      disasterPlagueRate = "0 60";
      
      disasterStack = $DisasterStack::Push;

   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 22;
      duration = 1000;
      
      fadeTime = 1;
      goldMin = 20;
      goldMax = 80;
      goldLow = 1;
      goldHigh = 5;
      lowCount = 1;
      highCount = 2;
      
      happinessCount = -10;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 20;
      addRequirement = well;
      duration = 35;
      
      cost = 1.0;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 15;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 2;
      spreadTime = 14;
      spreadChance = 35;
      spreadRadius = 20;
      spreadStrength = 1;
      
      damageTime = 0.5;
      damageStrength = 1;
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 90;
      duration = 60;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      
      radius = 7;
      damage = 25;
   };
   
   LoadScenario(%scenario);
}

function TorandoDisasterVeryHigh()
{
     %scenario = new SLScenario()
   {
      // update disasters only; do not change the map
      stack = true;
      
      // every 70 secs, a disaster can occur
      addDisasterNode = "0 45 3";
      
      // frequency pool, respawning time
      disasterBanditRate = "25 120";
      disasterDroughtRate = "10 60";
      disasterFireRate = "15 120";
      disasterTornadoRate = "60 50"; 
      disasterEarthquakeRate = "0 60";
      disasterFamineRate = "0 60";
      disasterPlagueRate = "0 60";
      
      disasterStack = $DisasterStack::Push;

   };
   
   // update the bandit scenario
   %scenario.disasterBanditScenario = new SLBanditAttackScenario()
   {
      chance = 40;
      duration = 1000;
      
      fadeTime = 1;
      goldMin = 20;
      goldMax = 80;
      goldLow = 1;
      goldHigh = 5;
      lowCount = 1;
      highCount = 2;
      
      happinessCount = -10;
      happinessIncrease = 0;
      happinessPlateau = 10;
      happinessDecrease = 0;
   };
   
   // update the drought scenario
   %scenario.disasterDroughtScenario = new SLDroughtScenario()
   {
      chance = 50;
      addRequirement = well;
      duration = 35;
      
      cost = 1.0;
   };
   
   // update the fire scenario
   %scenario.disasterFireScenario = new SLFireScenario()
   {
      chance = 25;
      duration = -1;
      
      startStrength = 2;
      
      spreadCount = 2;
      spreadTime = 14;
      spreadChance = 35;
      spreadRadius = 20;
      spreadStrength = 1;
      
      damageTime = 0.5;
      damageStrength = 1;
   };
   
   // update the tornado scenario
   %scenario.disasterTornadoScenario = new SLTornadoScenario()
   {
      object = "tornado";

      chance = 100;
      duration = 60;

      travelAngle = 35;
      travelRandom = 25;
      travelTimeLow = 3;
      travelTimeHigh = 6;
      travelSpeedLow = 3;
      travelSpeedHigh = 5;
      
      radius = 7;
      damage = 25;
   };
   
   LoadScenario(%scenario);
}  
// Updates Counter everytime a player building is built.
function TornadoBuildingCnt::onMessage(%vertex, %type, %param)
{
   Parent::onMessage(%vertex, %type, %param);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }
   %list =  slgGetServerBuildingList();
   %count = 0; 
   for(%index = 0; %index < %list.getSize(); %index++)
   {
      %object = %list.getID(%index);
      if(%object.isOnTeam($OST_PLAYER))
      {
         if(%object.isTownBuilding())
         {
            %cmpBldg = slgQueryInterface(%object, $CID_BUILDING);
            if( %cmpBldg.getState() == $BuildingState::Production)
            {
               %count++;
            }
         }
      }
   }
   if(%count >= $tornadoBldgCnt)
   {
      
      //Quest log
      %buildpast = "You have "@%count-1@" out of "@$tornadoBldgCnt@" buildings needed.";
      %buildnum = "You have "@$tornadoBldgCnt@" out of "@$tornadoBldgCnt@" buildings needed.";
      tsReplaceTaskInTracker($tornadoQuest,%buildpast,%buildnum,"Build up the size of your town to "@$tornadoBldgCnt@" buildings.");
      
      if (rsGetResourceCount($Resource::Happiness) >= $tornadoHappyCnt && %count >= $tornadoBldgCnt)
      { 
         //Quest Log         
         //Both buildings and happiness requirement completed.
         tsCompleteTaskInTracker($tornadoQuest, %buildnum);
         tsCompleteTaskInTracker($tornadoQuest, "Maintain a Town Happiness of "@$tornadoHappyCnt);
         TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoComplete", $TSV_AVAIL);
         TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoBuildingCnt", $TSV_CLOSED);
         TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoDestroyCnt", $TSV_CLOSED);
         
      }
      else
      {
         //Quest Log          
         //Only Building requirement completed          
         tsCompleteTaskInTracker($tornadoQuest, %buildnum);
         tsAddTaskToTracker($tornadoQuest, "Maintain a Town of "@$tornadoBldgCnt@" Buildings.", "Maintain a Town of "@$tornadoBldgCnt@" Buildings.");
                
         TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoHappiness", $TSV_AVAIL);
         TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoBuildingCnt", $TSV_CLOSED);
         TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoDestroyCnt", $TSV_CLOSED);
         TorandoDisasterVeryHigh();
      }
   }
   else
   {
      
      //Quest log
      %buildnum = "You have "@%count@" out of "@$tornadoBldgCnt@" buildings needed.";
      %buildpast = "You have "@%count-1@" out of "@$tornadoBldgCnt@" buildings needed.";
      tsReplaceTaskInTracker($tornadoQuest,%buildpast,%buildnum,"Build up the size of your town to "@$tornadoBldgCnt@" buildings.");
      
      %vertex.decCompleteCount();
      TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoBuildingCnt", $TSV_AVAIL);
            
   }
}

// Check for destroyed buildings

function TornadoDestroyCnt::onMessage(%vertex, %type, %param)
{
   // check if a building is destroyed
   Parent::onMessage(%vertex, %type, %param);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }
   %list =  slgGetServerBuildingList();
   %count = 0; 
   for(%index = 0; %index < %list.getSize(); %index++)
   {
      %object = %list.getID(%index);
      if(%object.isOnTeam($OST_PLAYER))
      {
         if(%object.isTownBuilding())
         {
            %cmpBldg = slgQueryInterface(%object, $CID_BUILDING);
            if( %cmpBldg.getState() == $BuildingState::Production)
            {
               %count++;
            }
         }
      }
   }
   if(%count < $tornadoBldgCnt-1)
   {
      
      %buildnum = "You have "@%count@" out of "@$tornadoBldgCnt@" buildings needed.";
      %buildpast = "You have "@%count+1@" out of "@$tornadoBldgCnt@" buildings needed.";
      tsReplaceTaskInTracker($tornadoQuest,%buildpast,%buildnum,"Build up the size of your town to "@$tornadoBldgCnt@" buildings.");
   }
   
   %vertex.decCompleteCount();
   TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoDestroyCnt", $TSV_AVAIL);           
}

function TornadoHappiness::onUpdate(%vertex)
{
   // check if we have enough happiness
	if (rsGetResourceCount($Resource::Happiness) >= $tornadoHappyCnt) 
	{
      
      %list =  slgGetServerBuildingList();
      %count = 0; 
      for(%index = 0; %index < %list.getSize(); %index++)
      {
         %object = %list.getID(%index);
         if(%object.isOnTeam($OST_PLAYER))
         {
            if(%object.isTownBuilding())
            {
               %cmpBldg = slgQueryInterface(%object, $CID_BUILDING);
               if( %cmpBldg.getState() == $BuildingState::Production)
               {
                  %count++;
               }
            }
         }
      }
      if(%count >= $tornadoBldgCnt)
      {
         TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoHappiness", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoComplete", $TSV_AVAIL);
         //TaskModifier.strMarkVertex("TornadoValleyTasks", "TornadoDestroyCnt", $TSV_CLOSED);
         // Quest log
         tsCompleteTaskInTracker($tornadoQuest, "Maintain a Town of "@$tornadoBldgCnt@" Buildings.");
         tsCompleteTaskInTracker($tornadoQuest, "Maintain a Town Happiness of "@$tornadoHappyCnt);
         
      }
	}
}
function TornadoComplete::onExit(%this)
{
   tsSendTaskPopUpDlg("ID_TASK_TornadoValley", "ID_TornadoWin", $TaskButton::More, "herocharacter");
   tsSendTaskPopUpDlg("ID_TASK_TornadoValley", "ID_TornadoEndAccept", $TaskButton::Okay, "herocharacter", "ID_TornadoEndAccept");  
}
function TornadoCompleteTwo::onExit()
{
   // Spawn Mayor type character maybe ???
}
// Returns to main map after dialog 
function TornadoValleyExit::onExit(%this)
{
   %scenario = new SLScenario() {
      stack = false;
   };
   LoadScenario(%scenario, endTornadoValleyTasks, winTornadoValley);
   
   // complete the tornado valley satellite
   mapsatellite_tornadovalley.disabled = false;
}